/*
 * Decompiled with CFR 0.152.
 */
package software.sava.core.encoding;

public final class CompactU16Encoding {
    private static final int SIGNED_BYTE_MASK = 128;
    private static final int MAX_TWO_BYTE_LEN = 16383;
    private static final int MAX_VALUE = 262143;

    public static boolean signedByte(int bite) {
        return (bite & 0x80) == 128;
    }

    public static byte[] encodeLength(int len) {
        if (len <= 127) {
            return new byte[]{(byte)(len & 0x7F)};
        }
        if (len <= 16383) {
            byte[] out = new byte[]{(byte)(len & 0x7F | 0x80), (byte)(len >> 7 & 0x7F)};
            return out;
        }
        if (len <= 262143) {
            byte[] out = new byte[]{(byte)(len & 0x7F | 0x80), (byte)(len >> 7 & 0x7F | 0x80), (byte)(len >> 14 & 3)};
            return out;
        }
        throw new IllegalArgumentException("Max value of an Compact-U16, received " + len);
    }

    public static int encodeLength(byte[] out, int off, int len) {
        if (len <= 127) {
            out[off] = (byte)(len & 0x7F);
            return 1;
        }
        if (len <= 16383) {
            out[off] = (byte)(len & 0x7F | 0x80);
            out[off + 1] = (byte)(len >> 7 & 0x7F);
            return 2;
        }
        if (len <= 262143) {
            out[off] = (byte)(len & 0x7F | 0x80);
            out[off + 1] = (byte)(len >> 7 & 0x7F | 0x80);
            out[off + 2] = (byte)(len >> 14 & 3);
            return 3;
        }
        throw new IllegalArgumentException("Max value of an Compact-U16, received " + len);
    }

    public static int getByteLen(byte[] data, int offset) {
        if ((data[offset] & 0x80) == 128) {
            return (data[offset + 1] & 0x80) == 128 ? 3 : 2;
        }
        return 1;
    }

    public static int getByteLen(int len) {
        if (len <= 127) {
            return 1;
        }
        if (len <= 16383) {
            return 2;
        }
        if (len <= 262143) {
            return 3;
        }
        throw new IllegalArgumentException("Max value of an Compact-U16, received " + len);
    }

    public static int decode(byte[] out, int off) {
        byte b0 = out[off];
        if ((b0 & 0x80) == 128) {
            byte b1 = out[off + 1];
            if ((b1 & 0x80) == 128) {
                return out[off + 2] << 14 | (b1 & 0x7F) << 7 | b0 & 0x7F;
            }
            return b1 << 7 | b0 & 0x7F;
        }
        return b0;
    }

    private CompactU16Encoding() {
    }
}

