/*
 * Decompiled with CFR 0.152.
 */
package software.sava.core.programs;

import java.util.Arrays;
import java.util.function.Predicate;
import software.sava.core.encoding.ByteUtil;
import software.sava.core.programs.DiscriminatorRecord;
import software.sava.core.tx.Instruction;

public interface Discriminator
extends Predicate<Instruction> {
    public static final int NATIVE_DISCRIMINATOR_LENGTH = 4;
    public static final int ANCHOR_DISCRIMINATOR_LENGTH = 8;

    public static Discriminator createDiscriminator(byte[] discriminator) {
        return new DiscriminatorRecord(discriminator);
    }

    public static Discriminator createDiscriminator(byte[] data, int offset, int length) {
        byte[] discriminator = new byte[length];
        System.arraycopy(data, offset, discriminator, 0, length);
        return Discriminator.createDiscriminator(discriminator);
    }

    public static Discriminator createDiscriminator(byte[] data, int length) {
        return Discriminator.createDiscriminator(data, 0, length);
    }

    public static Discriminator createAnchorDiscriminator(byte[] data, int offset) {
        return Discriminator.createDiscriminator(data, offset, 8);
    }

    public static Discriminator createAnchorDiscriminator(byte[] data) {
        return Discriminator.createAnchorDiscriminator(data, 0);
    }

    public static Discriminator toDiscriminator(int ... val) {
        int len = val.length;
        byte[] d = new byte[len];
        for (int i = 0; i < len; ++i) {
            d[i] = (byte)val[i];
        }
        return new DiscriminatorRecord(d);
    }

    public static byte[] serializeDiscriminator(Enum<?> ixEnum) {
        byte[] data = new byte[4];
        ByteUtil.putInt32LE(data, 0, ixEnum.ordinal());
        return data;
    }

    public static void serializeDiscriminator(byte[] data, Enum<?> ixEnum) {
        ByteUtil.putInt32LE(data, 0, ixEnum.ordinal());
    }

    public byte[] data();

    default public int length() {
        return this.data().length;
    }

    default public int write(byte[] bytes, int offset) {
        byte[] data = this.data();
        System.arraycopy(data, 0, bytes, offset, data.length);
        return data.length;
    }

    default public int write(byte[] bytes) {
        return this.write(bytes, 0);
    }

    default public boolean equals(byte[] data, int offset) {
        int len = data.length - offset;
        byte[] thisData = this.data();
        return len >= thisData.length && Arrays.equals(thisData, 0, thisData.length, data, offset, offset + thisData.length);
    }

    @Override
    default public boolean test(Instruction ix) {
        return this.equals(ix.data(), ix.offset());
    }

    default public int[] toIntArray() {
        byte[] data = this.data();
        int[] d = new int[data.length];
        for (int i = 0; i < d.length; ++i) {
            d[i] = data[i] & 0xFF;
        }
        return d;
    }
}

