/*
 * Decompiled with CFR 0.152.
 */
package software.sava.core.rpc;

import software.sava.core.accounts.PublicKey;
import software.sava.core.encoding.Base58;
import software.sava.core.rpc.DataSizeFilter;
import software.sava.core.rpc.MemCmpFilter;

public sealed interface Filter
permits DataSizeFilter, MemCmpFilter {
    public static final int MAX_MEM_COMP_LENGTH = 128;

    public static Filter createDataSizeFilter(int dataSize) {
        return new DataSizeFilter(dataSize);
    }

    public static Filter createMemCompFilter(int offset, byte[] data) {
        if (data.length > 128) {
            throw new IllegalStateException("Maximum memory compare filter size is 128 bytes.");
        }
        return new MemCmpFilter(offset, Base58.encode(data));
    }

    public static Filter createMemCompFilter(int offset, PublicKey publicKey) {
        return new MemCmpFilter(offset, publicKey.toBase58());
    }

    public static Filter createMemCompFilter(int offset, PublicKey publicKey, PublicKey publicKey2) {
        byte[] data = new byte[64];
        publicKey.write(data, 0);
        publicKey2.write(data, 32);
        return Filter.createMemCompFilter(offset, data);
    }

    public String toJson();
}

