/*
 * Decompiled with CFR 0.152.
 */
package software.sava.core.tx;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import software.sava.core.accounts.PublicKey;
import software.sava.core.accounts.lookup.AccountIndexLookupTableEntry;
import software.sava.core.accounts.meta.AccountMeta;
import software.sava.core.programs.Discriminator;
import software.sava.core.tx.InstructionRecord;

public interface Instruction {
    public static Instruction createInstruction(AccountMeta programId, List<AccountMeta> keys, byte[] data, int offset, int len) {
        return new InstructionRecord(programId, keys, data, offset, len);
    }

    public static Instruction createInstruction(AccountMeta programId, List<AccountMeta> keys, byte[] data) {
        return Instruction.createInstruction(programId, keys, data, 0, data.length);
    }

    public static Instruction createInstruction(AccountMeta programId, List<AccountMeta> keys, Discriminator discriminator) {
        return Instruction.createInstruction(programId, keys, discriminator.data());
    }

    public static Instruction createInstruction(PublicKey programId, List<AccountMeta> keys, byte[] data, int offset, int len) {
        return Instruction.createInstruction(AccountMeta.createInvoked(programId), keys, data, offset, len);
    }

    public static Instruction createInstruction(PublicKey programId, List<AccountMeta> keys, byte[] data) {
        return Instruction.createInstruction(programId, keys, data, 0, data.length);
    }

    public Instruction extraAccounts(List<AccountMeta> var1);

    public Instruction extraAccount(AccountMeta var1);

    public Instruction extraAccounts(Collection<PublicKey> var1, Function<PublicKey, AccountMeta> var2);

    public Instruction extraAccount(PublicKey var1, Function<PublicKey, AccountMeta> var2);

    public int serializedLength();

    public int mergeAccounts(Map<PublicKey, AccountMeta> var1);

    public int serialize(byte[] var1, int var2, AccountIndexLookupTableEntry[] var3);

    public int serialize(byte[] var1, int var2, Map<PublicKey, Integer> var3);

    public AccountMeta programId();

    public List<AccountMeta> accounts();

    public int[] discriminator(int var1);

    public Discriminator wrapDiscriminator(int var1);

    public boolean beginsWith(byte[] var1);

    public byte[] data();

    public byte[] copyData();

    public int offset();

    public int len();
}

