/*
 * Decompiled with CFR 0.152.
 */
package software.sava.core.tx;

import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import software.sava.core.accounts.PublicKey;
import software.sava.core.accounts.lookup.AccountIndexLookupTableEntry;
import software.sava.core.accounts.meta.AccountMeta;
import software.sava.core.encoding.CompactU16Encoding;
import software.sava.core.programs.Discriminator;
import software.sava.core.tx.Instruction;
import software.sava.core.tx.Transaction;

record InstructionRecord(AccountMeta programId, List<AccountMeta> accounts, byte[] data, int offset, int len) implements Instruction
{
    @Override
    public Instruction extraAccounts(List<AccountMeta> accounts) {
        int numAccounts = accounts.size();
        if (numAccounts == 0) {
            return this;
        }
        if (numAccounts == 1) {
            return this.extraAccount(accounts.getFirst());
        }
        AccountMeta[] joined = new AccountMeta[this.accounts.size() + numAccounts];
        int i = 0;
        for (AccountMeta account : this.accounts) {
            joined[i++] = account;
        }
        for (AccountMeta account : accounts) {
            joined[i++] = account;
        }
        return new InstructionRecord(this.programId, Arrays.asList(joined), this.data, this.offset, this.len);
    }

    @Override
    public Instruction extraAccount(AccountMeta account) {
        if (account == null) {
            return this;
        }
        AccountMeta[] joined = new AccountMeta[this.accounts.size() + 1];
        int i = 0;
        for (AccountMeta a : this.accounts) {
            joined[i++] = a;
        }
        joined[i] = account;
        return new InstructionRecord(this.programId, Arrays.asList(joined), this.data, this.offset, this.len);
    }

    @Override
    public Instruction extraAccounts(Collection<PublicKey> accounts, Function<PublicKey, AccountMeta> metaFactory) {
        int numAccounts = accounts.size();
        if (numAccounts == 0) {
            return this;
        }
        AccountMeta[] joined = new AccountMeta[this.accounts.size() + numAccounts];
        int i = 0;
        for (AccountMeta accountMeta : this.accounts) {
            joined[i++] = accountMeta;
        }
        for (PublicKey publicKey : accounts) {
            joined[i++] = metaFactory.apply(publicKey);
        }
        return new InstructionRecord(this.programId, Arrays.asList(joined), this.data, this.offset, this.len);
    }

    @Override
    public Instruction extraAccount(PublicKey account, Function<PublicKey, AccountMeta> metaFactory) {
        if (account == null) {
            return this;
        }
        AccountMeta[] joined = new AccountMeta[this.accounts.size() + 1];
        int i = 0;
        for (AccountMeta a : this.accounts) {
            joined[i++] = a;
        }
        joined[i] = metaFactory.apply(account);
        return new InstructionRecord(this.programId, Arrays.asList(joined), this.data, this.offset, this.len);
    }

    @Override
    public int serializedLength() {
        int numAccounts = this.accounts.size();
        return 1 + CompactU16Encoding.getByteLen(numAccounts) + numAccounts + CompactU16Encoding.getByteLen(this.len) + this.len;
    }

    @Override
    public int mergeAccounts(Map<PublicKey, AccountMeta> accounts) {
        for (AccountMeta meta : this.accounts) {
            accounts.merge(meta.publicKey(), meta, Transaction.MERGE_ACCOUNT_META);
        }
        accounts.merge(this.programId.publicKey(), this.programId, Transaction.MERGE_ACCOUNT_META);
        return this.serializedLength();
    }

    @Override
    public int serialize(byte[] out, int i, AccountIndexLookupTableEntry[] accountIndexLookupTable) {
        out[i] = AccountIndexLookupTableEntry.lookupAccountIndexOrThrow(accountIndexLookupTable, this.programId.publicKey());
        ++i;
        i += CompactU16Encoding.encodeLength(out, i, this.accounts.size());
        for (AccountMeta account : this.accounts) {
            out[i++] = AccountIndexLookupTableEntry.lookupAccountIndexOrThrow(accountIndexLookupTable, account.publicKey());
        }
        i += CompactU16Encoding.encodeLength(out, i, this.len);
        System.arraycopy(this.data, this.offset, out, i, this.len);
        return i + this.len;
    }

    @Override
    public int serialize(byte[] out, int i, Map<PublicKey, Integer> accountIndexLookupTable) {
        out[i] = AccountIndexLookupTableEntry.indexOfOrThrow(accountIndexLookupTable, this.programId.publicKey());
        ++i;
        i += CompactU16Encoding.encodeLength(out, i, this.accounts.size());
        for (AccountMeta account : this.accounts) {
            out[i++] = AccountIndexLookupTableEntry.indexOfOrThrow(accountIndexLookupTable, account.publicKey());
        }
        i += CompactU16Encoding.encodeLength(out, i, this.len);
        System.arraycopy(this.data, this.offset, out, i, this.len);
        return i + this.len;
    }

    @Override
    public int[] discriminator(int len) {
        int[] discriminator = new int[len];
        int i = this.offset;
        for (int d = 0; d < len; ++d) {
            discriminator[d] = this.data[i] & 0xFF;
            ++i;
        }
        return discriminator;
    }

    @Override
    public Discriminator wrapDiscriminator(int len) {
        return Discriminator.createDiscriminator(Arrays.copyOfRange(this.data, this.offset, this.offset + len));
    }

    @Override
    public boolean beginsWith(byte[] data) {
        int len = data.length;
        if (len <= this.len) {
            return Arrays.equals(this.data, this.offset, this.offset + len, data, 0, len);
        }
        return false;
    }

    @Override
    public byte[] copyData() {
        byte[] data = new byte[this.len];
        System.arraycopy(this.data, this.offset, data, 0, this.len);
        return data;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof InstructionRecord) {
            InstructionRecord ix = (InstructionRecord)o;
            return ix.len == this.len && this.programId.equals(ix.programId) && this.accounts.equals(ix.accounts) && Arrays.equals(ix.data, ix.offset, ix.offset + ix.len, this.data, this.offset, this.offset + this.len);
        }
        return false;
    }

    @Override
    public String toString() {
        String accountsJson = this.accounts != null && !this.accounts.isEmpty() ? this.accounts.stream().map(accountMeta -> accountMeta == null ? "?" : accountMeta.toString()).collect(Collectors.joining(",", "[", "]")).indent(4).stripTrailing() : "[]";
        String dataBase64 = this.data != null && this.len > 0 ? Base64.getEncoder().encodeToString(Arrays.copyOfRange(this.data, this.offset, this.offset + this.len)) : "";
        return String.format("{\n  \"programId\": \"%s\",\n  \"accounts\": %s,\n  \"data\": \"%s\"\n}", this.programId.publicKey().toBase58(), accountsJson, dataBase64);
    }
}

